set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518951';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03',
      43,
      NULL,
      '1102020',
      17.935125,
      3,
      0,
      1,
      '014032',
      0,
      ' 8-28-1998',
      28,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.100419,
      1.802635,
      0,
      1.008631,
      1,
      0.632216,
      NULL,
      1.199930,
      0.858092,
      0,
      0,
      0.540885,
      0,
      0.969233,
      NULL,
      1,
      5,
      NULL,
      5,
      0,
      5.277404,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.834916,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.170871,
      NULL,
      NULL,
      3.402352,
      2.323480,
      0,
      1.597525,
      3,
      3,
      NULL,
      0.345195,
      NULL,
      NULL,
      2,
      NULL,
      0.639904,
      NULL,
      0.712464,
      0,
      2.440493,
      1,
      NULL,
      0.288844,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.166067,
      0.386097,
      1,
      1,
      0.868822,
      1,
      1.232115,
      NULL,
      1,
      0.855812,
      1,
      1,
      0.297194,
      NULL,
      1.821580,
      0.435992,
      NULL,
      0,
      0.511469,
      1,
      NULL,
      NULL,
      0.391597,
      7,
      0,
      NULL,
      NULL,
      0.624178,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      0,
      4.356975,
      4,
      3,
      5,
      5,
      5.550180,
      NULL,
      5,
      7,
      7,
      NULL,
      1.999760,
      0.533188,
      NULL,
      0.867524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051910,
      1.913554,
      NULL,
      NULL,
      1.204888,
      1,
      0.456703,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4.589351,
      0,
      NULL,
      1.772342,
      NULL,
      NULL,
      NULL,
      NULL,
      3.279923,
      1.041168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      0.514581,
      0,
      NULL,
      NULL,
      1,
      0.890205,
      NULL,
      1,
      1,
      0.618904,
      0,
      0,
      0,
      1.944528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719586,
      '31140',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


