set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      '32',
      2,
      20,
      '2011002',
      54.578615,
      NULL,
      3.793128,
      3,
      NULL,
      2,
      ' 2-10-1987',
      31,
      38,
      1,
      NULL,
      2.358883,
      NULL,
      NULL,
      1.658702,
      3,
      NULL,
      2.417200,
      1.939487,
      NULL,
      1.810301,
      NULL,
      0.188505,
      1.007623,
      1.730885,
      NULL,
      0,
      0,
      0.005997,
      1.101650,
      6,
      1,
      0,
      7,
      0,
      NULL,
      1.035271,
      1,
      NULL,
      NULL,
      NULL,
      0.478458,
      NULL,
      NULL,
      0,
      0.213883,
      0.532009,
      1.180340,
      0,
      1,
      1.427279,
      3.641995,
      1,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      1.173182,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.849248,
      NULL,
      NULL,
      NULL,
      1.308010,
      0.857931,
      0.104311,
      0,
      NULL,
      0.711616,
      1.377218,
      NULL,
      0,
      1.491451,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      0.276143,
      NULL,
      NULL,
      0,
      4,
      0.559927,
      3.956560,
      NULL,
      1.055507,
      2.760929,
      1,
      2,
      5.599308,
      NULL,
      0,
      1,
      1,
      9,
      1,
      8,
      NULL,
      6,
      1,
      8,
      6,
      2.029492,
      7,
      9,
      3.584294,
      1.953942,
      NULL,
      0,
      1,
      1.727075,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475130,
      0.516075,
      2,
      0,
      0.258691,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.939431,
      NULL,
      9,
      2.250053,
      3.672601,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.816195,
      0,
      2.298251,
      5.740700,
      1.411921,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.409459,
      2.340277,
      1.067129,
      NULL,
      0.846302,
      NULL,
      3.779688,
      NULL,
      0,
      NULL,
      1.578353,
      1.991950,
      0,
      0,
      1,
      NULL,
      0.211386,
      NULL,
      3.470831,
      0.608934,
      NULL,
      1.786359,
      1.695585,
      1,
      1,
      2,
      0,
      0.123410,
      NULL,
      NULL,
      2,
      0.077937,
      2.705350,
      NULL,
      1,
      3,
      0,
      1.774757,
      0,
      NULL,
      0.008432,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.226976,
      4,
      1.993054,
      3.616835,
      3,
      2,
      1,
      2,
      2.838538);
commit;
end;
/


