set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '031',
      '04343110',
      48.276412,
      37.484868,
      '3224204',
      38,
      5,
      NULL,
      0,
      NULL,
      NULL,
      ' 7-14-1995',
      51.100205,
      38.724684,
      0,
      NULL,
      1,
      0.982967,
      1.679527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      0.009451,
      NULL,
      1,
      2,
      1.873581,
      3,
      1,
      0,
      0,
      4.952259,
      0,
      1,
      0.971720,
      NULL,
      1,
      NULL,
      NULL,
      1.787785,
      NULL,
      NULL,
      NULL,
      1,
      0.372139,
      1.274763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.245105,
      0.138826,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486372,
      1.429009,
      1.108926,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.868184,
      NULL,
      0.686742,
      0.948490,
      0,
      1,
      NULL,
      1.640443,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.491495,
      7,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      7,
      8.051212,
      6.907560,
      0,
      3.747830,
      11,
      0,
      NULL,
      4,
      4,
      2,
      0.046822,
      1.313879,
      NULL,
      NULL,
      4.840408,
      1.449462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.330016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868775,
      NULL,
      6,
      NULL,
      0.995617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0.859015,
      NULL,
      NULL,
      NULL,
      1.256091,
      1.237184,
      0,
      1.416596,
      0,
      2,
      0.497372,
      NULL,
      NULL,
      NULL,
      1.081824,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.836800,
      NULL,
      0.280013,
      1.645811,
      3.434429,
      2,
      NULL,
      1,
      2,
      3,
      0.355008,
      1.602654,
      1,
      1,
      0.803860,
      1.030042,
      0.362297,
      NULL,
      NULL,
      1,
      1,
      0,
      1.484904,
      1.421101,
      3.277627,
      1,
      1.972787,
      0.380842,
      0.856057,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      3.077983,
      0,
      0.345545,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '34101',
      '31134',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.608621,
      0.197135,
      2.512735,
      2,
      3.488500,
      3,
      0,
      0,
      0);
commit;
end;
/


