set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14001034',
      29,
      48.060549,
      '0244030',
      19.107240,
      NULL,
      NULL,
      NULL,
      '442330',
      3.091432,
      NULL,
      39.600776,
      64,
      0,
      NULL,
      0.433922,
      1,
      1,
      NULL,
      2.815520,
      0,
      NULL,
      0.003457,
      0,
      1.378480,
      4.080410,
      1,
      1,
      1.992610,
      1.638159,
      1.149036,
      NULL,
      1.037219,
      5,
      NULL,
      3.898101,
      1.993666,
      3.433900,
      NULL,
      3,
      1.933294,
      2,
      1.126591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.702082,
      1,
      0.788956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306168,
      1,
      0,
      NULL,
      NULL,
      0.699380,
      1,
      0.434569,
      1,
      0.849447,
      0,
      NULL,
      1.567536,
      1,
      0.507745,
      1,
      1,
      1,
      0.885479,
      NULL,
      1,
      1,
      0,
      1.928849,
      2.013151,
      NULL,
      7,
      NULL,
      3,
      0,
      NULL,
      5,
      7,
      NULL,
      5.985400,
      1.271480,
      3.598632,
      4,
      5.562462,
      2.725490,
      NULL,
      NULL,
      NULL,
      11,
      6.093565,
      1,
      4,
      NULL,
      0.301669,
      NULL,
      NULL,
      4.578007,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349698,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764061,
      NULL,
      7.913670,
      2.655667,
      3.818332,
      1.331310,
      1.672044,
      3.305344,
      1.155422,
      0.791157,
      NULL,
      NULL,
      3,
      0.547981,
      NULL,
      NULL,
      NULL,
      5.435727,
      2,
      4.351855,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.599753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      3,
      3.670039,
      3,
      3.127491,
      0.466392,
      1.370211,
      NULL,
      0.195432,
      1.951881,
      NULL,
      0.655041,
      0,
      1,
      1,
      1.460682,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.643827,
      '02213',
      NULL,
      '',
      0.082916,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4.514783,
      1,
      1.820292,
      2.953547,
      2,
      4,
      0.612572,
      2.187037,
      0);
commit;
end;
/


