set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '013',
      '32331330',
      NULL,
      38,
      '3033110',
      19,
      3,
      3.055549,
      0,
      '423204',
      1,
      ' 7-14-1975',
      12.859445,
      47,
      1,
      NULL,
      2.841311,
      0,
      0,
      1.578151,
      3.865380,
      0,
      1.562079,
      0.685144,
      0,
      0.735315,
      5.679261,
      0,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      2.295706,
      0,
      1.233530,
      1,
      0.365102,
      1,
      1.541413,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.380711,
      NULL,
      NULL,
      0,
      1.560314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.810177,
      NULL,
      0,
      NULL,
      1,
      1,
      1.766901,
      0.736319,
      1,
      1.688686,
      0.270231,
      1,
      NULL,
      NULL,
      NULL,
      1.150311,
      0.657326,
      1,
      NULL,
      1,
      5,
      1,
      0,
      NULL,
      1.968035,
      1,
      0,
      NULL,
      3,
      3,
      2,
      2,
      NULL,
      6.520470,
      0.262100,
      NULL,
      1.588282,
      3.968403,
      2.286396,
      3.276966,
      1,
      3.266200,
      NULL,
      0,
      NULL,
      1.262364,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125833,
      0.388987,
      1,
      1,
      0,
      NULL,
      1,
      1.929674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      1.726666,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398962,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.276129,
      2,
      1,
      1.725130,
      NULL,
      NULL,
      NULL,
      1.592812,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.668949,
      1.448474,
      2.944325,
      1,
      1.544490,
      0.695086,
      3,
      3.245868,
      1.451300,
      1,
      0,
      0.565175,
      0.460084,
      NULL,
      0,
      1,
      0.339417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.064491,
      '10104',
      '42140',
      '',
      1.050425,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      5.653239,
      NULL,
      3.658510,
      2.127798,
      0,
      NULL,
      1.596713,
      2,
      3.172848);
commit;
end;
/


