set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32424011',
      62.608832,
      24,
      '2101124',
      NULL,
      NULL,
      0.626845,
      NULL,
      '020213',
      NULL,
      NULL,
      NULL,
      12,
      0.961656,
      NULL,
      3.203497,
      2.478877,
      NULL,
      1,
      2,
      NULL,
      2.052260,
      1,
      0.839818,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      4.743441,
      1,
      0,
      1,
      5,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.946043,
      NULL,
      NULL,
      1,
      0.113636,
      0,
      1.837872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.196117,
      1.484195,
      5,
      NULL,
      0,
      1.896100,
      0,
      NULL,
      NULL,
      0.904599,
      NULL,
      NULL,
      1.190065,
      0,
      1.218197,
      0.254598,
      NULL,
      0,
      1,
      1.931365,
      1.730811,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.059477,
      1,
      0,
      NULL,
      NULL,
      1.372494,
      2,
      NULL,
      1,
      NULL,
      1,
      4.037109,
      1,
      2.988527,
      2.723242,
      NULL,
      2,
      4.223752,
      1,
      NULL,
      1,
      NULL,
      8,
      4,
      NULL,
      7.786259,
      5,
      NULL,
      NULL,
      1.374783,
      1.498897,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.450324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198773,
      0.970420,
      2,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.565500,
      3.838231,
      2,
      2.121930,
      2,
      1,
      1.263953,
      NULL,
      7,
      2,
      1.716094,
      NULL,
      NULL,
      NULL,
      7.572616,
      NULL,
      NULL,
      3,
      5.988049,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1.618057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.086223,
      0,
      0.919464,
      0.321496,
      1,
      0.810156,
      NULL,
      1,
      1,
      0.312390,
      NULL,
      0,
      0,
      NULL,
      0,
      0.387091,
      1.026492,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '42044',
      '31002',
      '',
      0,
      '',
      NULL,
      '',
      0.225954,
      '',
      NULL,
      NULL,
      5.808214,
      1.084725,
      NULL,
      3.161533,
      0.430951,
      1,
      NULL,
      2.261990,
      NULL);
commit;
end;
/


