set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '32344412',
      NULL,
      56,
      NULL,
      55,
      6,
      3,
      0,
      '420312',
      3.024434,
      '10-18-2003',
      35,
      50.970818,
      0.815216,
      NULL,
      NULL,
      0.339577,
      NULL,
      0.687382,
      1,
      1.603309,
      1.524976,
      1.766901,
      0.604059,
      NULL,
      2.497337,
      NULL,
      0,
      1.075259,
      1,
      0,
      4,
      1,
      5,
      0.489251,
      1,
      NULL,
      1,
      1,
      1,
      1.744958,
      2.869467,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.232682,
      0,
      1,
      NULL,
      0.809029,
      0,
      3.961692,
      0,
      0,
      2.360707,
      1,
      0,
      1,
      NULL,
      0.677547,
      0.328009,
      0,
      1.789305,
      0.407204,
      1,
      0.791669,
      0.400208,
      3.393783,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.114745,
      NULL,
      NULL,
      0.438372,
      NULL,
      NULL,
      1,
      NULL,
      0.260169,
      0.178269,
      0.581340,
      0,
      0,
      0,
      1,
      0.098415,
      1.644678,
      NULL,
      NULL,
      0.728388,
      0.871211,
      NULL,
      NULL,
      1,
      4.281654,
      0.087803,
      1.796629,
      5,
      0.346350,
      NULL,
      0,
      0,
      2,
      5.910812,
      5,
      0.059778,
      1,
      4.854343,
      1.640149,
      5.732772,
      10,
      NULL,
      9,
      0.987820,
      NULL,
      7.504051,
      0.410970,
      6.341154,
      0.289314,
      NULL,
      3.141311,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523202,
      1.795250,
      1,
      1,
      0.784560,
      0.316883,
      NULL,
      0.574999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      3,
      2.923338,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4.144410,
      1,
      9,
      2.130910,
      3.896982,
      2,
      0.301420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302730,
      NULL,
      1,
      1.717179,
      1,
      NULL,
      2.604584,
      1.694468,
      1,
      1,
      3.279450,
      0,
      NULL,
      0.279171,
      1,
      1.310368,
      1.441618,
      0.111111,
      0,
      0.248816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      '24024',
      '10303',
      '',
      0,
      '',
      NULL,
      '',
      1.595305,
      '20343',
      '',
      '',
      NULL,
      NULL,
      3,
      3.155847,
      2,
      5.955507,
      0.110950,
      0,
      4);
commit;
end;
/


