set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02101244',
      2.520619,
      33,
      '0304344',
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.610599,
      ' 9- 0-1981',
      4,
      46,
      NULL,
      NULL,
      3,
      3,
      0.678100,
      1.451722,
      2,
      1.648472,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.425499,
      NULL,
      1,
      NULL,
      1,
      4,
      1.151002,
      NULL,
      1,
      NULL,
      1,
      2.844233,
      0.338162,
      1,
      0.206651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.494443,
      0.994200,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.959766,
      1.394272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800909,
      1,
      0,
      0.445607,
      0,
      0,
      0.333749,
      1.529106,
      1,
      1,
      0.937008,
      NULL,
      0,
      1,
      0,
      1.920836,
      NULL,
      1.995572,
      1,
      NULL,
      0,
      4,
      1,
      0.156141,
      6,
      1,
      7,
      0.239395,
      3.631526,
      3.925125,
      NULL,
      9,
      0.987606,
      0,
      NULL,
      NULL,
      4,
      NULL,
      9,
      0,
      7.098570,
      NULL,
      0,
      NULL,
      2.533351,
      3,
      1.566173,
      4.245111,
      0,
      NULL,
      NULL,
      2.106824,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999627,
      1,
      0,
      NULL,
      NULL,
      0,
      1.655425,
      1.364138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      2,
      3.693558,
      4,
      3.539789,
      3.814643,
      0,
      1,
      0,
      4.976120,
      0.691263,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4.297915,
      1,
      2.928753,
      NULL,
      0.443818,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.821007,
      0,
      2,
      3,
      NULL,
      0,
      2.065474,
      0.716196,
      NULL,
      0,
      1.192362,
      0.014359,
      0.038832,
      1,
      1,
      NULL,
      1.063490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.908699,
      '01310',
      '01323',
      '',
      0,
      '',
      NULL,
      '',
      3,
      '02324',
      '',
      '',
      2,
      2,
      2,
      0.699526,
      2.790507,
      NULL,
      3.181061,
      NULL,
      NULL);
commit;
end;
/


