set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02201343',
      50,
      40.112610,
      NULL,
      55,
      NULL,
      1,
      2,
      '203204',
      3.835074,
      ' 1- 2-1991',
      40.372220,
      24,
      1,
      NULL,
      0.085357,
      NULL,
      0,
      1,
      1,
      0.560211,
      3.530589,
      NULL,
      1,
      1,
      0.192725,
      1,
      0,
      NULL,
      0.277577,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.071262,
      2,
      0,
      2.467927,
      1.874149,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.291243,
      1.837774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405714,
      1.080986,
      1.718663,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.419818,
      3,
      NULL,
      0,
      1,
      1.738701,
      0.641994,
      0,
      0.830839,
      1,
      NULL,
      1.261256,
      1,
      1,
      1.986967,
      1,
      1.898300,
      NULL,
      NULL,
      0.361829,
      NULL,
      0.263171,
      0.923913,
      NULL,
      1,
      4.017238,
      1,
      2.710297,
      4.086921,
      1,
      3,
      3,
      0,
      1.119125,
      0,
      1,
      3.169605,
      0,
      1.298757,
      2,
      10,
      3,
      NULL,
      NULL,
      3.473135,
      1.047408,
      2.313474,
      1.587853,
      NULL,
      NULL,
      2.582585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031608,
      1,
      0,
      0,
      0.599953,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.873083,
      2.530873,
      0.563879,
      NULL,
      NULL,
      NULL,
      2,
      0.477764,
      NULL,
      NULL,
      NULL,
      7.587669,
      NULL,
      6.605674,
      0,
      1,
      2,
      1.613729,
      NULL,
      NULL,
      NULL,
      0.295629,
      1.931560,
      0.592272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.128127,
      1.767368,
      3,
      0.153380,
      2,
      1.288418,
      1,
      3,
      3.774216,
      NULL,
      1,
      1.565806,
      1,
      0,
      0,
      NULL,
      1.091113,
      0.771448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '42234',
      '12240',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      '40234',
      NULL,
      '',
      5,
      5.673297,
      3,
      NULL,
      3.185461,
      NULL,
      NULL,
      2,
      1.153210);
commit;
end;
/


