set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '030',
      '14044232',
      7.934571,
      0.567864,
      '0320411',
      6,
      NULL,
      1.301781,
      0,
      '400431',
      1.668629,
      ' 6-18-1983',
      26.721736,
      1.330873,
      0.845606,
      NULL,
      11,
      1,
      1,
      0.070981,
      NULL,
      1.402300,
      1,
      0,
      1.377843,
      0.322205,
      5.478063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.016570,
      0.686780,
      1.228415,
      0,
      0,
      1.953229,
      2.959256,
      1.470339,
      NULL,
      NULL,
      1.744529,
      NULL,
      NULL,
      5.674077,
      NULL,
      2,
      3,
      1.415556,
      0,
      1,
      3,
      NULL,
      3,
      1,
      0.201494,
      1.400072,
      1,
      0.819917,
      1.366457,
      2.853173,
      1.042521,
      0,
      1.397512,
      0.950912,
      1,
      NULL,
      0,
      0,
      2,
      0.256249,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.268675,
      2.544162,
      0,
      5.151888,
      NULL,
      1,
      NULL,
      1.751053,
      1.094392,
      1,
      NULL,
      0,
      1.870388,
      1.711253,
      NULL,
      1,
      0,
      0.030151,
      NULL,
      NULL,
      5.459911,
      0,
      3.413658,
      4.871507,
      NULL,
      7,
      1,
      2,
      0,
      0,
      5,
      1.347849,
      NULL,
      NULL,
      0.889398,
      0,
      0,
      5.753198,
      7,
      6,
      5,
      2,
      NULL,
      1.497679,
      4.892446,
      4,
      4,
      0,
      NULL,
      NULL,
      4.751133,
      1.063773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995502,
      1,
      1,
      0,
      1.625585,
      1.623897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0.563601,
      0.216541,
      NULL,
      0,
      1.030087,
      1,
      NULL,
      NULL,
      NULL,
      4.209589,
      1,
      1.686572,
      2.801556,
      1.817832,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.368714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743854,
      3.950058,
      1.801120,
      NULL,
      2,
      3,
      1,
      0,
      0,
      0.470281,
      0,
      NULL,
      0,
      NULL,
      1.620292,
      1.969175,
      0.457876,
      1.389775,
      1,
      1.109356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '44142',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.603270,
      '',
      '',
      '',
      2,
      1.907789,
      0,
      1.558106,
      4.121770,
      0,
      2,
      1.303533,
      1);
commit;
end;
/


