set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0232',
      NULL,
      35,
      NULL,
      '1032321',
      2.181646,
      1,
      1.018750,
      3,
      '030433',
      4.982805,
      ' 8-16-1991',
      28,
      40,
      1,
      NULL,
      12,
      0,
      0.252834,
      NULL,
      0.419554,
      0,
      0.370486,
      1,
      1,
      1.609844,
      9.655094,
      3.097651,
      NULL,
      0.003506,
      1.067121,
      NULL,
      6.320744,
      1.005454,
      1.310439,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.628665,
      1.163589,
      0.507125,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      0,
      2.825437,
      NULL,
      1,
      1.434426,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.627790,
      0,
      1.506989,
      NULL,
      0,
      1,
      1,
      1,
      1,
      6,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      3,
      NULL,
      0.929046,
      1,
      0.704837,
      1.358431,
      0,
      1.664900,
      1.682498,
      1,
      1,
      1.487883,
      NULL,
      0.829947,
      1,
      1,
      1.029100,
      NULL,
      1,
      0.297245,
      1,
      0.655562,
      4.759728,
      1.071537,
      1.489018,
      0,
      6,
      1,
      3,
      2,
      0.766466,
      1,
      0,
      0.055089,
      1.738714,
      2.494704,
      0,
      NULL,
      4,
      1,
      NULL,
      1,
      0.655744,
      4,
      NULL,
      4.718149,
      NULL,
      3.118440,
      1.490365,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      1.404313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.740306,
      NULL,
      3,
      2.740664,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.300208,
      NULL,
      1.471700,
      NULL,
      NULL,
      NULL,
      1,
      1.415636,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.971586,
      0,
      NULL,
      1.656380,
      2.448487,
      0.269805,
      1,
      NULL,
      0,
      0,
      0.302396,
      1.930164,
      NULL,
      1,
      0,
      0.476610,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '31000',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      6,
      3,
      2.407605,
      5.161044,
      2.552956,
      2.291679,
      1,
      0.287848);
commit;
end;
/


