set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '2213201',
      NULL,
      6,
      NULL,
      3,
      '302111',
      2.951795,
      ' 8- 3-1995',
      18,
      NULL,
      0,
      NULL,
      0.740267,
      3.872895,
      1,
      1.657583,
      0,
      1.846798,
      1,
      1.984263,
      1.838742,
      0,
      7.609203,
      1,
      0,
      1,
      NULL,
      1.415718,
      0.967013,
      NULL,
      NULL,
      1,
      1.006893,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.699970,
      NULL,
      NULL,
      0.274382,
      0,
      0,
      1.500860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.396293,
      1,
      0.452929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.214333,
      NULL,
      1,
      2,
      2,
      4.085710,
      0,
      1.881631,
      NULL,
      3.644883,
      NULL,
      0.450409,
      5,
      0.001622,
      1.089275,
      0.030764,
      0,
      1.336994,
      NULL,
      NULL,
      4.239128,
      NULL,
      3.319834,
      NULL,
      0.048439,
      0.134839,
      NULL,
      3.460301,
      0,
      1.936223,
      8.512756,
      NULL,
      2,
      NULL,
      6,
      1.701712,
      9.105965,
      0,
      9.126290,
      7,
      0,
      6.842844,
      4.682246,
      8,
      4.444336,
      NULL,
      NULL,
      3.195045,
      0.745433,
      1.818708,
      4.294253,
      0.406427,
      NULL,
      1.908214,
      0.827916,
      3,
      1,
      1.542432,
      4.451497,
      0,
      2,
      2.456673,
      1.014319,
      3,
      0.461009,
      1.780405,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.480186,
      0,
      NULL,
      3,
      3.031496,
      1,
      0.422566,
      NULL,
      NULL,
      NULL,
      1,
      0.927863,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.906795,
      1.344328,
      1.050319,
      0,
      NULL,
      3.646099,
      1,
      3.032376,
      3.211385,
      0.812338,
      0.122812,
      1,
      0,
      1,
      1.293887,
      0,
      1.565167,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '43330',
      '',
      '',
      0.890621,
      '',
      '',
      '',
      0.332259,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


