set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '4444430',
      66.923961,
      1,
      2,
      NULL,
      '021344',
      2.861029,
      ' 2-18-1992',
      35.516882,
      NULL,
      1,
      NULL,
      3,
      1.683089,
      2,
      1,
      NULL,
      3,
      0.995097,
      1.006171,
      3.503912,
      1.998519,
      3.729129,
      1,
      3.382836,
      4.852078,
      NULL,
      0.643758,
      6.135244,
      1,
      3,
      1.666884,
      1.332594,
      0.222952,
      9.492012,
      1,
      2,
      5.188756,
      0.333719,
      0,
      1,
      4.617394,
      1.707542,
      NULL,
      NULL,
      0.476089,
      0.601469,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.879434,
      1.666391,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.363589,
      7,
      0,
      0.123939,
      1.940641,
      NULL,
      1.268015,
      1.179022,
      NULL,
      6.047709,
      0.299998,
      1.974711,
      NULL,
      0,
      1.278923,
      0.369568,
      1.256270,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.196092,
      1,
      NULL,
      NULL,
      1,
      6,
      0,
      0,
      7.692953,
      0.369845,
      1.079575,
      1,
      0.357805,
      0.642829,
      11,
      3.139669,
      0,
      0.454596,
      0.685425,
      8,
      2.238251,
      4.857505,
      8,
      10.049910,
      8,
      2.896009,
      3.020155,
      NULL,
      0.751092,
      NULL,
      NULL,
      0,
      1,
      3,
      1.988938,
      7,
      0,
      2,
      1,
      0,
      5,
      0.050147,
      1.673281,
      1.885201,
      14.954592,
      3.712563,
      3,
      1.802760,
      0.445485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.164363,
      0.476904,
      1,
      3.570533,
      3,
      NULL,
      6,
      1.746885,
      NULL,
      NULL,
      5,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      10,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000606,
      2.639449,
      NULL,
      0.704989,
      0.616507,
      2,
      0.881735,
      0.766866,
      2.094732,
      3.057694,
      NULL,
      0,
      1.281101,
      0.085104,
      NULL,
      NULL,
      NULL,
      1.647300,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.842832,
      '34442',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.766604,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


