set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1303',
      '10444024',
      16,
      28,
      '0443344',
      NULL,
      NULL,
      0,
      2,
      '004442',
      1.545841,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      1.696007,
      0,
      0,
      0.253622,
      1.353343,
      3.908300,
      2.004882,
      1.773749,
      NULL,
      1.574781,
      2.322722,
      1,
      0.987984,
      1.556491,
      5,
      NULL,
      3.415872,
      0,
      1,
      1.937804,
      0.296133,
      1.237853,
      3,
      0,
      2.458164,
      1,
      0.518613,
      NULL,
      3.417282,
      0.661975,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390943,
      NULL,
      0.037345,
      3.722093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638025,
      7,
      6.925937,
      0.450394,
      NULL,
      3,
      5,
      0,
      NULL,
      NULL,
      0.623870,
      NULL,
      0.380079,
      1,
      1,
      0,
      1.763355,
      1,
      0,
      NULL,
      0.353697,
      1.527283,
      4.524622,
      NULL,
      NULL,
      1,
      2.989934,
      0,
      NULL,
      1.490302,
      NULL,
      4,
      5,
      NULL,
      1,
      1.636292,
      NULL,
      NULL,
      1,
      NULL,
      6.929807,
      7,
      5.133220,
      6,
      4,
      3,
      NULL,
      NULL,
      0.869308,
      1,
      1.858420,
      NULL,
      6,
      NULL,
      1,
      0,
      3.809130,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      6,
      2.424115,
      0,
      NULL,
      1,
      1.002425,
      4,
      NULL,
      NULL,
      2.833274,
      1.168710,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1,
      1.218359,
      0,
      4,
      NULL,
      NULL,
      NULL,
      1.306238,
      3.562787,
      1.684751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.255265,
      0.197671,
      3.781103,
      NULL,
      0.653429,
      NULL,
      NULL,
      1.107043,
      2.254146,
      1,
      1.835275,
      0,
      0,
      0,
      0,
      0.531638,
      0.640632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33242',
      '40344',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      '43044',
      '3232',
      4.206947,
      1.962040,
      NULL,
      3.454196,
      2.081575,
      5,
      2,
      NULL,
      0);
commit;
end;
/


