set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      '222423',
      2,
      ' 6-11-2003',
      43,
      NULL,
      0.317064,
      NULL,
      0.348162,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.017496,
      1,
      7,
      0.887091,
      0.228287,
      1,
      1,
      NULL,
      4.092213,
      0,
      6,
      NULL,
      1,
      1.182493,
      1,
      1,
      0,
      0,
      2.111038,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.762688,
      NULL,
      1.363397,
      NULL,
      0,
      1,
      NULL,
      0.590953,
      NULL,
      0.110319,
      3.961283,
      NULL,
      0.319301,
      0,
      3,
      0,
      NULL,
      NULL,
      1.359942,
      1,
      NULL,
      4,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.635102,
      1.864577,
      0,
      1,
      1.166676,
      1.796176,
      1,
      0.011254,
      0,
      1.168923,
      0.186828,
      0,
      1.282542,
      NULL,
      0.280181,
      1.416355,
      NULL,
      0,
      NULL,
      1.398986,
      1.372696,
      0.054934,
      0,
      2.603385,
      1.919568,
      1,
      1,
      4.020063,
      3.715096,
      1,
      NULL,
      4.886046,
      1,
      1.754047,
      4.954294,
      NULL,
      NULL,
      5.676179,
      NULL,
      4.660780,
      7,
      0,
      0,
      NULL,
      2,
      1.303693,
      0,
      0.635179,
      3.016191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298618,
      NULL,
      0,
      1,
      1.702222,
      2,
      0,
      0.188523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.269037,
      NULL,
      NULL,
      NULL,
      5,
      0.306025,
      5.878882,
      0,
      1,
      1,
      1.921299,
      NULL,
      NULL,
      NULL,
      0.564164,
      1.593304,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.153864,
      1,
      1,
      NULL,
      0.148388,
      1.069484,
      1,
      2,
      0.413257,
      1.066955,
      0.338314,
      1.681878,
      0.947552,
      0.334919,
      0,
      0.911628,
      1.396958,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '01422',
      '',
      NULL,
      0.406952,
      '',
      '',
      '',
      0.226241,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


