set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '2101012',
      7.907440,
      2,
      0,
      NULL,
      '011431',
      NULL,
      '10- 9-1979',
      19.087246,
      NULL,
      1,
      NULL,
      10.853470,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.219535,
      NULL,
      0.849057,
      0,
      1,
      0,
      0,
      NULL,
      1.800262,
      1,
      NULL,
      1.355184,
      1.895617,
      1,
      NULL,
      0.547675,
      NULL,
      NULL,
      5.439676,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.729150,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.957020,
      1.789525,
      0.676851,
      NULL,
      0,
      0,
      1,
      1.947701,
      0,
      NULL,
      1,
      1.085675,
      1.713108,
      0,
      NULL,
      1.748240,
      7.696281,
      0,
      0,
      3.818460,
      0.282511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143294,
      0.570422,
      0.878266,
      0.854608,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1.798976,
      0.002904,
      NULL,
      0.209645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.026985,
      2.087327,
      NULL,
      3.622973,
      0,
      0.967080,
      1.134631,
      0.124978,
      1.166441,
      1.290984,
      NULL,
      1.365046,
      0.853605,
      1,
      8.265986,
      NULL,
      2,
      9,
      1.257147,
      3,
      0,
      4.554374,
      1.936498,
      4,
      0.950454,
      2.056276,
      0,
      1.138810,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.520591,
      1.463229,
      0.397108,
      1.295265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.523265,
      NULL,
      NULL,
      NULL,
      NULL,
      2.785174,
      1,
      1.423555,
      1.145066,
      2.880619,
      0,
      0.532905,
      NULL,
      NULL,
      NULL,
      0,
      3.999603,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720899,
      2.831239,
      1,
      NULL,
      1.098456,
      NULL,
      0,
      NULL,
      0.486457,
      3.548144,
      1.388587,
      1.108961,
      0.378021,
      1,
      0,
      1.605124,
      1.120701,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '24441',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


