set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '0032301',
      NULL,
      2,
      NULL,
      1,
      '412324',
      0.832394,
      ' 1-14-1985',
      12,
      NULL,
      1.014247,
      NULL,
      NULL,
      NULL,
      1.070956,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.207723,
      0,
      6,
      NULL,
      0.962076,
      NULL,
      NULL,
      1.305304,
      2.087180,
      0.982227,
      2.520114,
      1,
      1.992236,
      0.868358,
      7.857690,
      0,
      0,
      NULL,
      1,
      0.157994,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.497392,
      2,
      2,
      2.284164,
      NULL,
      0.316971,
      3,
      3,
      2.111344,
      0.204678,
      2.780545,
      0,
      0.219659,
      NULL,
      1,
      3.854830,
      1,
      0.151049,
      0.515131,
      0.477783,
      NULL,
      NULL,
      6,
      1,
      2,
      2.340492,
      1,
      NULL,
      NULL,
      1.124056,
      NULL,
      NULL,
      0.800807,
      NULL,
      4.447869,
      0.806870,
      4,
      0.587793,
      1.652246,
      NULL,
      NULL,
      1.545265,
      1.517279,
      1,
      NULL,
      NULL,
      1.079076,
      0.084121,
      0.729994,
      1,
      NULL,
      NULL,
      1.369812,
      NULL,
      1,
      0.065736,
      2.379259,
      3.594766,
      NULL,
      NULL,
      3.146003,
      1,
      3,
      1,
      0,
      NULL,
      5,
      1,
      NULL,
      2,
      4.254587,
      5.360636,
      NULL,
      0,
      NULL,
      1.230171,
      5,
      0.243257,
      NULL,
      0.291998,
      2,
      1,
      NULL,
      4.421338,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567588,
      0,
      0,
      0,
      0.562413,
      2,
      0.626074,
      1.891460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.351340,
      1,
      1.809577,
      NULL,
      NULL,
      NULL,
      NULL,
      3.006111,
      0,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.653443,
      2.651157,
      1.177373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.922220,
      2,
      NULL,
      3.908099,
      NULL,
      0.343696,
      3,
      1,
      2.933236,
      0.988596,
      0.212036,
      NULL,
      1.127438,
      0.725938,
      1.099872,
      NULL,
      0,
      0.813222,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.331009,
      '34412',
      '',
      '',
      1.084438,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


