set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '1441311',
      NULL,
      1,
      2.860587,
      1,
      '411334',
      NULL,
      ' 2-21-1994',
      NULL,
      NULL,
      1,
      NULL,
      7.711853,
      2.898317,
      1.018336,
      0,
      3.047575,
      0,
      1.971200,
      NULL,
      1.168355,
      NULL,
      2.679917,
      NULL,
      4,
      2,
      0,
      0.224176,
      4.215223,
      0.203454,
      2,
      1,
      3,
      1.456698,
      2,
      1,
      0,
      NULL,
      4.265317,
      1.940325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.780716,
      0,
      3.734146,
      3,
      0.660952,
      0,
      0,
      1.345101,
      2,
      1.725216,
      NULL,
      0,
      0.705146,
      1.539464,
      1,
      NULL,
      2,
      NULL,
      3,
      4,
      0.359254,
      NULL,
      8.330375,
      NULL,
      2,
      2.810691,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.548816,
      0.916779,
      0.916852,
      0,
      1,
      NULL,
      0.970428,
      NULL,
      1,
      NULL,
      1.422240,
      NULL,
      NULL,
      0,
      1,
      0.234527,
      0.385044,
      1.222398,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      4,
      1.426437,
      0,
      1,
      1.400059,
      5,
      1,
      NULL,
      3,
      0,
      1,
      0.121147,
      5,
      NULL,
      NULL,
      2.923042,
      6,
      2.556860,
      7,
      3.228118,
      8.904515,
      7,
      3,
      1.247493,
      0.449875,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      0,
      1.224459,
      1.066744,
      1.847689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.686212,
      NULL,
      3.685750,
      NULL,
      1.223867,
      4.903110,
      0.641332,
      NULL,
      0,
      2.141328,
      0,
      4,
      2.508282,
      1.651601,
      NULL,
      NULL,
      NULL,
      4.832023,
      1.822227,
      NULL,
      2.026411,
      0,
      1,
      3.164474,
      NULL,
      NULL,
      NULL,
      0.435022,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.175519,
      2.678815,
      3,
      1,
      3,
      NULL,
      1.344950,
      NULL,
      1.616895,
      1,
      0.569473,
      1.989184,
      1,
      0,
      NULL,
      0.800660,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '24113',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.727081,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


