set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '2043343',
      NULL,
      NULL,
      NULL,
      2,
      '342233',
      NULL,
      ' 5-16-1996',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.781920,
      NULL,
      0.917837,
      0.810199,
      3,
      0.262565,
      2.257285,
      0,
      1,
      1,
      0.958090,
      0.471719,
      0,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      0.362931,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.956951,
      1,
      2.569785,
      NULL,
      1,
      1.564556,
      3,
      NULL,
      2.075440,
      0,
      0,
      0.285482,
      3,
      NULL,
      1,
      0.038930,
      1.356882,
      1,
      0,
      1,
      NULL,
      5,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      2.614533,
      0.630522,
      NULL,
      NULL,
      0.499069,
      1,
      1.560597,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.806039,
      0.377738,
      0.572420,
      0,
      1,
      NULL,
      0,
      0,
      0.470012,
      NULL,
      NULL,
      NULL,
      5.214549,
      NULL,
      3,
      0,
      3.442093,
      6.350231,
      1.618280,
      1.549560,
      NULL,
      1.675543,
      3.369568,
      7,
      3,
      7,
      1.083638,
      0,
      3.605523,
      0,
      7.110362,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.782581,
      NULL,
      NULL,
      1.004042,
      NULL,
      NULL,
      NULL,
      1.517412,
      0.352956,
      0,
      1,
      1.735940,
      3,
      0.582598,
      NULL,
      NULL,
      NULL,
      4.540647,
      NULL,
      4,
      4.859113,
      1,
      1,
      0.141375,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.036905,
      1.644102,
      1.779446,
      1,
      NULL,
      NULL,
      NULL,
      3.062249,
      1.140582,
      NULL,
      0.214317,
      1,
      1.617180,
      1.567081,
      NULL,
      0.238315,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.192061,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.086041,
      0,
      0.266601,
      NULL,
      0.246304,
      NULL,
      0,
      1,
      2,
      '02044',
      NULL,
      '',
      0.648648,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


