set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.263076,
      0,
      NULL,
      0.995259,
      ' 6-28-1977',
      41,
      NULL,
      1,
      NULL,
      0,
      1,
      1.507149,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1.804506,
      0,
      1,
      4,
      0,
      1,
      0.201963,
      0.135307,
      1,
      2,
      NULL,
      NULL,
      0,
      0.962208,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.189285,
      1,
      NULL,
      0.924195,
      0.109136,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3.529857,
      2,
      1,
      NULL,
      0.373548,
      1,
      0.763258,
      2,
      2,
      NULL,
      NULL,
      0,
      1,
      0.061904,
      NULL,
      NULL,
      NULL,
      1.611377,
      NULL,
      NULL,
      0,
      NULL,
      3.023198,
      3.546661,
      0.167031,
      0,
      0,
      0,
      0.792298,
      1,
      3,
      0.509973,
      1.354459,
      2.667670,
      0,
      0.229773,
      0,
      NULL,
      0,
      NULL,
      0.921070,
      0,
      1.509300,
      1.261231,
      1,
      1.941659,
      1,
      1,
      1,
      NULL,
      NULL,
      5,
      1.918235,
      1,
      NULL,
      NULL,
      2,
      1,
      4,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.050695,
      3.084199,
      1.680837,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903626,
      2,
      NULL,
      1.362383,
      0.650078,
      1,
      1.657366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.289392,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0,
      4.124158,
      1,
      0.199136,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.989436,
      4.291226,
      1.410053,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      6.194514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680300,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1.585815,
      1.126379,
      1.415317,
      0.619301,
      0.543840,
      0.804326,
      1,
      0,
      1.390477,
      0.389881,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '30300',
      NULL,
      '',
      0.626917,
      '',
      '',
      NULL,
      0.889735,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


