set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      74.058118,
      4,
      3,
      3,
      '443014',
      3.670128,
      ' 9- 5-1988',
      3.498161,
      NULL,
      NULL,
      NULL,
      0.112639,
      3.016026,
      0,
      0,
      1.744855,
      1.727792,
      1.987454,
      1.689901,
      2.972597,
      NULL,
      5.208957,
      0.255686,
      1,
      1,
      0.990811,
      0,
      NULL,
      1.593165,
      0,
      NULL,
      1,
      1.020836,
      NULL,
      NULL,
      0,
      0.670965,
      1.839229,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.128889,
      1,
      NULL,
      0.870270,
      0,
      1.724930,
      2.057317,
      NULL,
      3,
      0.850893,
      2,
      3,
      1.330643,
      NULL,
      1,
      2,
      NULL,
      1.361014,
      0.508852,
      3.662515,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      0.044062,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.018891,
      1,
      3.055091,
      0.486179,
      0,
      1,
      NULL,
      2,
      2,
      1.326058,
      0,
      1.465379,
      0.789848,
      0.494933,
      1,
      1.247658,
      0,
      NULL,
      1,
      0.566538,
      0,
      NULL,
      1.600712,
      NULL,
      0.983363,
      1.125117,
      0,
      0,
      0,
      0.157431,
      1,
      NULL,
      NULL,
      1,
      3.206617,
      8.393369,
      3,
      7.150883,
      NULL,
      0.007159,
      5,
      1,
      2.222246,
      0,
      1.349544,
      5,
      0.237439,
      NULL,
      NULL,
      NULL,
      1.396007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.824493,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.350067,
      NULL,
      NULL,
      NULL,
      7.870556,
      3.132291,
      1.712827,
      NULL,
      NULL,
      NULL,
      4.701269,
      1,
      4.496960,
      2,
      0,
      2,
      4.482396,
      1.561814,
      NULL,
      NULL,
      1,
      4.953015,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.785374,
      NULL,
      1,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.187426,
      0.975289,
      0.212802,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.821777,
      '44414',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


