set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3342',
      '43143031',
      NULL,
      NULL,
      '0210302',
      204,
      NULL,
      NULL,
      3,
      '330041',
      0.240391,
      '11- 5-1989',
      61,
      21.541104,
      0.884742,
      NULL,
      0.016783,
      1.897165,
      2,
      1,
      0,
      0,
      0,
      2.863389,
      1.964072,
      0,
      1,
      0.251123,
      NULL,
      0.704429,
      0.166797,
      1.055113,
      0.469570,
      0,
      0,
      1,
      NULL,
      NULL,
      0.528777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243921,
      1.338070,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.074971,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.237259,
      NULL,
      1.755440,
      0,
      0.030731,
      0,
      0,
      0.914000,
      1.029084,
      1.507730,
      NULL,
      0.508951,
      0,
      0,
      1.322103,
      0.149656,
      NULL,
      1,
      0,
      0.031081,
      1,
      1,
      NULL,
      0.165463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301604,
      NULL,
      2,
      0.557975,
      1,
      0.880162,
      2,
      2.672793,
      NULL,
      1.316025,
      0.002585,
      4.365653,
      0,
      1,
      NULL,
      0.152510,
      1,
      NULL,
      NULL,
      6,
      0.271867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694430,
      0,
      NULL,
      1,
      NULL,
      1.766097,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320780,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.576279,
      NULL,
      0.855206,
      1.748755,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.086880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.346055,
      0,
      1,
      0,
      1.746496,
      1.437474,
      NULL,
      1,
      1.339233,
      NULL,
      1,
      1,
      NULL,
      0,
      0.774194,
      1,
      NULL,
      0,
      1.298754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '40213',
      '',
      '',
      1.409424,
      '',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0.458400,
      NULL,
      NULL,
      1.212373,
      3.057452,
      1.699225,
      0,
      1,
      3);
commit;
end;
/


