set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43430023',
      25.918993,
      24,
      '2424144',
      172,
      4,
      1.847905,
      1,
      '004100',
      5,
      NULL,
      25.983723,
      21,
      0.042117,
      NULL,
      1,
      0,
      0.912835,
      1.688687,
      1.407268,
      1,
      0.845647,
      NULL,
      1.949382,
      0.919290,
      0.535960,
      NULL,
      1,
      0,
      1.461567,
      NULL,
      1.752507,
      0.542781,
      1.703408,
      1.291666,
      1.838478,
      0.875204,
      1.914137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.093088,
      1.077251,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.182515,
      1.813442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.570977,
      NULL,
      1.856659,
      1.390226,
      1.139656,
      0,
      0.912275,
      1,
      0,
      NULL,
      0.786818,
      1,
      NULL,
      1,
      0,
      1.068053,
      0.624307,
      NULL,
      1,
      2.878116,
      1.672273,
      NULL,
      3,
      0.633527,
      2.864554,
      2.735764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306923,
      NULL,
      0.736554,
      1.468823,
      4,
      0,
      1.023230,
      NULL,
      1.088267,
      4,
      NULL,
      1.969564,
      0.703300,
      0,
      1.053131,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557166,
      0.794092,
      NULL,
      0,
      1.587897,
      0.786972,
      1,
      0.340118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.650706,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.912729,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.375083,
      0.201074,
      3,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.351483,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384993,
      NULL,
      0,
      0.855983,
      0.623323,
      0.095015,
      1.178213,
      0.033956,
      0,
      0,
      1,
      NULL,
      1,
      0.550449,
      0,
      0,
      1,
      NULL,
      1.432636,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.027375,
      '44342',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      4,
      1.445152,
      2,
      4.033366,
      3,
      NULL,
      1,
      0.352984,
      2.054242);
commit;
end;
/


