set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3300',
      '41001114',
      NULL,
      17.957606,
      '2033412',
      283,
      4,
      NULL,
      2,
      '024223',
      NULL,
      ' 0-17-1975',
      NULL,
      48,
      0.163731,
      NULL,
      0,
      0.809757,
      2,
      NULL,
      1,
      1.542741,
      0.124825,
      0.850199,
      1,
      NULL,
      0,
      1.719027,
      0.681733,
      1,
      NULL,
      1,
      0.314152,
      NULL,
      0.430702,
      1,
      0.016634,
      1.358150,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.719954,
      0.440184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.814787,
      0.806336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060710,
      1,
      1.995831,
      0,
      NULL,
      1.442751,
      0.832948,
      0,
      NULL,
      1.656874,
      1.723372,
      0,
      1,
      0.375997,
      1.003711,
      0,
      NULL,
      0.820426,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      1.919069,
      2.649127,
      0.194359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.279191,
      1.806702,
      1,
      2,
      0.415769,
      0,
      0,
      1.224882,
      0,
      2.402503,
      0,
      1.448467,
      1.618891,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.555923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926015,
      1.370863,
      1,
      0,
      0,
      NULL,
      1.704355,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386068,
      0,
      NULL,
      2.119609,
      0.554133,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.357300,
      NULL,
      0.143465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581321,
      0.000239,
      1.982221,
      1.461098,
      1.786845,
      NULL,
      NULL,
      3,
      1,
      2.203872,
      NULL,
      0.217871,
      1.230126,
      0.748070,
      0.805861,
      1,
      0.925813,
      1.636566,
      1.601663,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.416465,
      '02301',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1.491836,
      '',
      '',
      '',
      3,
      0.428869,
      1.925365,
      5,
      3,
      1.645405,
      NULL,
      3.332961,
      1);
commit;
end;
/


