set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829832';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12404034',
      NULL,
      31,
      '0241402',
      15.929753,
      NULL,
      1.829338,
      NULL,
      '424030',
      NULL,
      ' 5- 1-1993',
      53,
      129,
      NULL,
      NULL,
      1.141293,
      1.311250,
      2.876829,
      0.150979,
      NULL,
      NULL,
      0,
      3.642869,
      0.884423,
      1,
      2,
      1,
      1,
      NULL,
      0.599122,
      1,
      0,
      1,
      1.494245,
      0,
      0,
      NULL,
      4.618253,
      NULL,
      1.059160,
      0,
      0.627635,
      1.607143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.718908,
      0.660588,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868790,
      1.529981,
      NULL,
      1.842558,
      0.905242,
      NULL,
      NULL,
      NULL,
      0.621978,
      NULL,
      NULL,
      NULL,
      1,
      1.119532,
      NULL,
      0,
      1.525456,
      1,
      NULL,
      NULL,
      0.810009,
      1.600319,
      1.664651,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.911063,
      0,
      0.532556,
      7.754873,
      6,
      NULL,
      7.353867,
      7.996113,
      7.159017,
      2,
      2.122197,
      0.601057,
      0.570981,
      1,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.980917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6.760981,
      0.268212,
      1.866103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.783738,
      NULL,
      3.411050,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.626436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632240,
      0.491101,
      2.793952,
      1,
      0.457203,
      0.432366,
      1.143434,
      1,
      NULL,
      1,
      0.114690,
      NULL,
      0.592426,
      0,
      1,
      1.314697,
      0,
      0.846443,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.305148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455779,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272257,
      NULL,
      NULL,
      NULL,
      NULL,
      2.752411,
      1,
      NULL,
      NULL,
      1,
      0.508831,
      1.449854,
      1,
      0.268408,
      '20131',
      '',
      NULL,
      1,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      0,
      0,
      1.375473,
      NULL,
      2,
      1,
      2,
      2);
commit;
end;
/


