set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829832';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2440',
      '04202043',
      NULL,
      82,
      '3001414',
      12.204172,
      1,
      1,
      3,
      '410402',
      6,
      ' 7-23-1979',
      86.762953,
      11,
      0,
      NULL,
      1.951283,
      1,
      2.092863,
      1.084518,
      1,
      1.720778,
      NULL,
      2.439598,
      1,
      0.752113,
      3.019132,
      0,
      NULL,
      1.065123,
      1.664329,
      0,
      2.670554,
      1,
      0.754632,
      0.111886,
      0,
      1,
      0.538921,
      0,
      5.995253,
      NULL,
      NULL,
      1.394573,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.297724,
      0.575991,
      0,
      1,
      1,
      0.236706,
      1.315923,
      NULL,
      NULL,
      1,
      1.697180,
      1,
      1.747108,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1.381870,
      NULL,
      NULL,
      NULL,
      0.212857,
      0,
      2.855434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.652870,
      3,
      4,
      6.680709,
      4,
      4.005116,
      6,
      1,
      7.745592,
      NULL,
      NULL,
      0.535840,
      0,
      NULL,
      NULL,
      NULL,
      7.336467,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957452,
      1,
      0,
      1,
      1,
      0,
      1.105664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045427,
      NULL,
      1,
      NULL,
      0.543060,
      0.561542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893758,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      1,
      1.514624,
      NULL,
      NULL,
      NULL,
      0.396319,
      2,
      1.915492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664108,
      1,
      NULL,
      0.409868,
      1.801004,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      0.185027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '40401',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      2.663684,
      0,
      1,
      NULL,
      3,
      1,
      1,
      1.738660,
      3.568092);
commit;
end;
/


