set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9830316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '34312111',
      5.621260,
      74.816054,
      '3100034',
      8.406439,
      3,
      3.508953,
      2,
      '303123',
      2.616266,
      ' 9-12-1998',
      10,
      56,
      1,
      NULL,
      NULL,
      0.691231,
      0,
      0.781725,
      1,
      NULL,
      0.567628,
      2,
      1.768806,
      NULL,
      1.310177,
      1.967596,
      1,
      1,
      0,
      1.283200,
      1,
      0.004473,
      1.565466,
      1.307766,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127113,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.101842,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566099,
      0,
      1.064201,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0.893233,
      1,
      1.247734,
      1,
      0.602161,
      0,
      0.977498,
      1,
      0.299295,
      NULL,
      NULL,
      1.401814,
      1.193204,
      0,
      1,
      1,
      NULL,
      1.419853,
      NULL,
      NULL,
      NULL,
      0,
      1.912070,
      1,
      1.279210,
      1,
      0.446052,
      1.877714,
      0.567405,
      1.478261,
      2.910825,
      0.957862,
      0.477862,
      1.387014,
      NULL,
      1,
      1.631788,
      4.874552,
      NULL,
      NULL,
      NULL,
      8.595650,
      0.986607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024756,
      0.784621,
      1,
      0,
      1.779152,
      1,
      1.011513,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.885909,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.189146,
      1.030902,
      0.123965,
      1,
      2,
      5.252561,
      0.123032,
      NULL,
      NULL,
      1,
      2,
      0.976518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.633641,
      NULL,
      1.423357,
      NULL,
      0,
      1,
      0,
      0.852381,
      1,
      0.461668,
      NULL,
      NULL,
      1.158028,
      1.853564,
      1,
      0.450487,
      0,
      0.229791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.902010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '42213',
      '',
      '',
      1.578468,
      '',
      NULL,
      NULL,
      0.375519,
      '',
      '',
      '',
      2,
      3.646090,
      0,
      2.101685,
      2,
      1.580203,
      2.792755,
      2.313755,
      NULL);
commit;
end;
/


