set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9830316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4211',
      '41030243',
      NULL,
      31.679903,
      '3013324',
      51.928818,
      5,
      3,
      2,
      '334233',
      1,
      NULL,
      37,
      11,
      1,
      NULL,
      NULL,
      0.612704,
      2.700063,
      1.296386,
      1.448420,
      2,
      1.046284,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1.203310,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.976261,
      1,
      0.604979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427470,
      0,
      0.240527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.532714,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.355833,
      0.606531,
      0,
      NULL,
      1,
      0.768109,
      0.400665,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.986503,
      NULL,
      0.157686,
      NULL,
      NULL,
      NULL,
      1,
      1.329787,
      0,
      1,
      0.406186,
      0,
      NULL,
      0.775762,
      1.481532,
      0,
      0.187534,
      0.195683,
      1.011388,
      0,
      0.385765,
      NULL,
      0.497753,
      NULL,
      1,
      5.852838,
      1,
      1.767126,
      4,
      NULL,
      1,
      0,
      0.753645,
      1.130977,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.533942,
      NULL,
      1.356786,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210992,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.551636,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990902,
      NULL,
      1,
      NULL,
      0,
      1,
      0.483061,
      NULL,
      NULL,
      NULL,
      0.592870,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738082,
      0.485318,
      0,
      1.860786,
      1,
      0.384638,
      1,
      1.976324,
      1.514883,
      0,
      0,
      1.204566,
      0,
      0,
      0.761478,
      0.759926,
      NULL,
      0,
      0.879080,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '40232',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3.241789,
      '41023',
      '',
      '',
      2.823123,
      0.899353,
      0,
      0.371018,
      3,
      3,
      1,
      3,
      1.281637);
commit;
end;
/


