set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9830316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1014',
      NULL,
      88,
      54.184045,
      '0331444',
      29,
      5,
      0,
      2,
      '023412',
      2.303469,
      ' 5- 1-1992',
      2.403605,
      40.660750,
      NULL,
      NULL,
      1.029233,
      1,
      2,
      0,
      1,
      0.239944,
      0.243048,
      3.359596,
      0.071492,
      0,
      1,
      1,
      0.214479,
      0.702469,
      0,
      0.681481,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947047,
      1.888346,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962025,
      0.703404,
      0.173676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.702607,
      0.810867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916285,
      1,
      1.119085,
      1,
      1,
      0,
      NULL,
      NULL,
      1.500649,
      0,
      1.593385,
      0.631325,
      1,
      1.560605,
      0.783651,
      0.289977,
      1,
      1.294792,
      0,
      NULL,
      0,
      1,
      NULL,
      0.539638,
      NULL,
      1.815846,
      0,
      1.784006,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.682907,
      1,
      1.922163,
      NULL,
      1.684909,
      0.995024,
      0,
      3.720041,
      1,
      2,
      NULL,
      1.968577,
      NULL,
      0,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.038774,
      0.858380,
      0.702697,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374434,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149114,
      3,
      0.004773,
      NULL,
      NULL,
      NULL,
      1,
      0.199007,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.451932,
      0.136911,
      1.413353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278729,
      1.051908,
      0.979978,
      0,
      0,
      0.771254,
      0,
      1,
      1,
      0.314878,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.054155,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '01011',
      '',
      '',
      0.421310,
      '',
      NULL,
      '',
      2,
      NULL,
      '',
      '',
      NULL,
      3,
      1.652244,
      0.425978,
      5.296576,
      NULL,
      0.377736,
      2,
      1);
commit;
end;
/


