set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '3104414',
      65.927415,
      2,
      2.442900,
      1,
      '302222',
      NULL,
      ' 0- 6-2000',
      NULL,
      NULL,
      1,
      NULL,
      0.609399,
      NULL,
      1.282826,
      0,
      0,
      0,
      0.630511,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1.766114,
      0,
      1.169582,
      1,
      0,
      0,
      1.833888,
      1,
      0.234341,
      5.111593,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807119,
      NULL,
      NULL,
      0,
      0,
      1,
      0.431710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0.759651,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.469448,
      0,
      0.443986,
      1,
      NULL,
      NULL,
      0,
      0.776597,
      0,
      0,
      0.884096,
      NULL,
      0.982584,
      1,
      0.064694,
      0.447942,
      0,
      0.251264,
      NULL,
      0.813977,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0.338858,
      NULL,
      1.952591,
      1.341708,
      0,
      NULL,
      3.507616,
      0,
      1,
      8.293784,
      NULL,
      NULL,
      2,
      6,
      NULL,
      1.602595,
      1.510661,
      0.542667,
      0,
      1,
      1.335412,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.216975,
      0,
      NULL,
      0,
      1.924415,
      NULL,
      1,
      0.354269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743998,
      NULL,
      NULL,
      NULL,
      NULL,
      5.083243,
      NULL,
      2,
      1.091923,
      0.186671,
      NULL,
      7,
      1,
      1.437603,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.455423,
      4,
      0.217376,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.310667,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.914366,
      3,
      0.719713,
      1.634369,
      1,
      1,
      1,
      1.182026,
      0.534628,
      1,
      NULL,
      1,
      0.608019,
      0,
      0.493131,
      0.981727,
      NULL,
      0.582812,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '12401',
      '20234',
      '',
      0.212907,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


