set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '4031002',
      8.715362,
      3,
      3.093521,
      NULL,
      '221214',
      1,
      ' 4-16-1978',
      50.182769,
      NULL,
      0.048176,
      NULL,
      3,
      1.289630,
      NULL,
      0,
      0,
      0,
      1.271570,
      1.402540,
      0.401411,
      NULL,
      NULL,
      0.353179,
      1,
      1.645286,
      NULL,
      5.385046,
      NULL,
      1.634911,
      1,
      1,
      1.623230,
      1.460935,
      NULL,
      NULL,
      1,
      0.475702,
      0.128210,
      0,
      NULL,
      NULL,
      0.397024,
      NULL,
      NULL,
      1,
      NULL,
      1.504512,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581773,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.221164,
      3,
      0.966627,
      2,
      NULL,
      3.012376,
      1.351253,
      0.259382,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.392733,
      1.557968,
      1.384946,
      1,
      NULL,
      0,
      1,
      1.950547,
      NULL,
      0,
      1.187482,
      3.006114,
      1.200495,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      1.302961,
      3,
      NULL,
      5.957867,
      0,
      1.951624,
      5,
      5,
      9,
      0,
      0,
      1.524536,
      0.429891,
      NULL,
      NULL,
      5.218766,
      1.272641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245508,
      NULL,
      NULL,
      NULL,
      0.758363,
      1.671598,
      0,
      0.894248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803067,
      NULL,
      NULL,
      NULL,
      0.989648,
      0.639119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.720139,
      1.431855,
      NULL,
      NULL,
      NULL,
      2.915868,
      0.503113,
      NULL,
      5.059885,
      0.432571,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0.579829,
      0,
      NULL,
      NULL,
      1,
      1.620736,
      3.162869,
      1,
      3,
      0,
      1.771992,
      0,
      1,
      NULL,
      1.636225,
      1.588029,
      2,
      1.196951,
      1,
      0,
      NULL,
      NULL,
      0,
      1.181048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.201658,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


