set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      NULL,
      NULL,
      21.349588,
      '0422443',
      85.689287,
      5,
      0.321590,
      1,
      NULL,
      1.125704,
      ' 7- 6-1989',
      14,
      43.562963,
      1.970309,
      NULL,
      0,
      1.997604,
      2.800623,
      1,
      0.633428,
      0.814186,
      1,
      2.898400,
      0.112283,
      0.102309,
      5.130305,
      0,
      3,
      1,
      2,
      2.681752,
      2.774768,
      0,
      NULL,
      1.882831,
      1.993443,
      NULL,
      5,
      1,
      1,
      1.710825,
      1,
      0,
      NULL,
      NULL,
      1.964334,
      NULL,
      NULL,
      NULL,
      0.972601,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.533767,
      0.339060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719778,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.813573,
      NULL,
      0.028560,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156853,
      NULL,
      NULL,
      1.986309,
      0,
      0,
      3.207416,
      2,
      NULL,
      1.984757,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211600,
      1,
      1.778623,
      NULL,
      NULL,
      NULL,
      2.733958,
      7,
      4.418281,
      5,
      NULL,
      8,
      9.361539,
      0,
      0.314489,
      NULL,
      NULL,
      NULL,
      NULL,
      8.655929,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      0.332425,
      0.377086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.746044,
      4.974138,
      4.842741,
      3,
      0,
      1.609053,
      NULL,
      NULL,
      NULL,
      0,
      3.306403,
      0.198961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252531,
      0.000645,
      1.483629,
      1,
      NULL,
      0,
      NULL,
      1.400801,
      0,
      3.201454,
      3.683939,
      0.300147,
      0,
      NULL,
      0,
      1,
      1.505092,
      1.054513,
      0.480632,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '21412',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.067933,
      '',
      '',
      '',
      2,
      NULL,
      3.344208,
      NULL,
      2,
      2.673303,
      1.911028,
      3,
      1.842022);
commit;
end;
/


