set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      NULL,
      7,
      1.813938,
      '0001104',
      126.400602,
      1,
      1.654121,
      3,
      NULL,
      3.404938,
      ' 3-12-1990',
      35,
      45.031828,
      1.288668,
      NULL,
      0,
      NULL,
      3.010382,
      0.391774,
      1,
      0,
      NULL,
      NULL,
      0.930144,
      1,
      4.390775,
      1,
      2.499580,
      0,
      4,
      1.128481,
      0,
      0,
      NULL,
      0,
      0.066401,
      0.803843,
      5,
      0,
      1.563369,
      0,
      3.160051,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.237958,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378585,
      NULL,
      NULL,
      1.016673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091256,
      1.919899,
      1.637268,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.452123,
      NULL,
      NULL,
      1.157939,
      0.088764,
      1,
      1.513945,
      0,
      NULL,
      1.809094,
      NULL,
      NULL,
      1,
      1.332824,
      3,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137171,
      0.182239,
      NULL,
      1,
      1,
      6.394814,
      NULL,
      0.547684,
      5.316271,
      1,
      5,
      8.948001,
      6,
      1,
      0.545730,
      0,
      1.467912,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716064,
      0.548477,
      0,
      0,
      NULL,
      1.921541,
      0.924528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.824101,
      NULL,
      4,
      NULL,
      1.191189,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2,
      2,
      0,
      0.324186,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.458745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235172,
      NULL,
      0.679804,
      NULL,
      3.607728,
      0.200781,
      0.401372,
      1,
      0,
      2,
      NULL,
      0.591519,
      1,
      1,
      0,
      0.825207,
      0.918462,
      NULL,
      0.981159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '12114',
      '',
      NULL,
      0.060189,
      '',
      '',
      '',
      1.034632,
      '',
      '',
      '',
      0.457177,
      0.359969,
      0,
      1,
      0.327420,
      2,
      1.604514,
      1,
      1.241271);
commit;
end;
/


