set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31224031',
      72,
      36,
      NULL,
      165,
      5,
      NULL,
      2,
      '422241',
      3,
      ' 7-14-2002',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675000,
      2,
      0.720454,
      0,
      0.372671,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      1.599594,
      NULL,
      5,
      1,
      1,
      NULL,
      0.164812,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.988685,
      NULL,
      NULL,
      1,
      1.394146,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.899192,
      1.059829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.429803,
      0,
      1,
      0,
      1.206814,
      1,
      0.839037,
      NULL,
      0.682167,
      1.494430,
      0.466206,
      0,
      0.554313,
      0,
      0.614625,
      0.215560,
      0,
      0.855734,
      NULL,
      0,
      NULL,
      1,
      2.702155,
      0,
      0.595105,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122176,
      0,
      NULL,
      0.498093,
      0,
      0.726400,
      2,
      1.211687,
      NULL,
      6,
      NULL,
      2.380495,
      5,
      1,
      1.011558,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.677701,
      0,
      0,
      0,
      NULL,
      1,
      0.250116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709490,
      NULL,
      NULL,
      NULL,
      NULL,
      3.171323,
      3.996457,
      2.207362,
      0,
      0,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.942449,
      NULL,
      6.812024,
      NULL,
      3.549991,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4.951754,
      1.812253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057581,
      3,
      0,
      0,
      1,
      1.256444,
      0.614917,
      NULL,
      2,
      NULL,
      1.373636,
      0,
      0.847916,
      0,
      0,
      0,
      1.416157,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.968099,
      '03032',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      4.931814,
      1.801457,
      1.566571,
      NULL,
      3,
      3,
      3.772224,
      2,
      1.099894);
commit;
end;
/


