set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '403',
      '13412410',
      35,
      6.289920,
      '3124320',
      100,
      1,
      2.036331,
      0,
      '232134',
      NULL,
      ' 1-21-1990',
      12.739747,
      21,
      0,
      NULL,
      0,
      NULL,
      1.565417,
      1.058788,
      0.428310,
      0,
      0,
      1,
      1,
      1,
      4.178292,
      0,
      3,
      NULL,
      4.441974,
      0.183796,
      5,
      NULL,
      1,
      1.172884,
      1.611901,
      1.128435,
      0.337291,
      NULL,
      1.687881,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645229,
      NULL,
      1.704499,
      1.773458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.570230,
      1,
      0,
      1.226207,
      1,
      1.630746,
      0.448686,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.918215,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.053844,
      1.436772,
      2.986227,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279481,
      0.020536,
      1.076797,
      0.561313,
      5,
      1,
      6,
      6.940112,
      5.183621,
      8.446420,
      0.576218,
      9,
      3.023689,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.868647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.851580,
      1,
      0,
      1,
      0,
      0,
      0.516932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2.212009,
      0,
      1.084195,
      3.458979,
      NULL,
      1.033617,
      0.435501,
      NULL,
      NULL,
      NULL,
      1.874044,
      NULL,
      7,
      3.872958,
      2.308949,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.200339,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861046,
      0,
      0,
      0,
      1,
      0.046067,
      2.930270,
      0,
      0,
      0,
      0.528142,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.320707,
      1.996479,
      1,
      1.563693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '01344',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.910977,
      '',
      '',
      '',
      4,
      2.971034,
      NULL,
      3.442618,
      3.555562,
      0.572911,
      NULL,
      0.751712,
      0.118330);
commit;
end;
/


