set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02211314',
      14,
      64,
      '2012202',
      196,
      NULL,
      2.563443,
      2,
      '111030',
      3,
      NULL,
      56,
      67.288943,
      0,
      NULL,
      1.387279,
      1,
      1.773534,
      1.043221,
      1.732696,
      0.209839,
      NULL,
      2.379648,
      NULL,
      0.703205,
      5.432484,
      NULL,
      4.922548,
      1.551642,
      2,
      0.864159,
      1,
      NULL,
      1.546728,
      1,
      0.332671,
      1.749352,
      0,
      0,
      0.732031,
      NULL,
      1.283439,
      0.814102,
      NULL,
      NULL,
      1.529405,
      NULL,
      NULL,
      NULL,
      0.359818,
      0.135304,
      0.131363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.127270,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532732,
      1,
      2.733879,
      1.170307,
      3.739534,
      0,
      NULL,
      1.450308,
      1,
      0,
      1,
      0,
      0.561020,
      0,
      0,
      1.420881,
      0.700758,
      1.554807,
      0.630657,
      NULL,
      1,
      1,
      NULL,
      1.753304,
      0,
      1,
      1.791349,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335685,
      0.253564,
      NULL,
      1,
      0,
      1.986373,
      4,
      2,
      5,
      10.461717,
      NULL,
      8,
      9.827817,
      NULL,
      NULL,
      NULL,
      1.828062,
      NULL,
      NULL,
      7.469365,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834320,
      NULL,
      1,
      1,
      0,
      1.808123,
      1.508652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.860091,
      1,
      3,
      0.278778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079691,
      0.901921,
      3,
      2.226287,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.088304,
      2,
      1.891645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567403,
      0,
      2.451506,
      0.280990,
      1,
      0.099409,
      1,
      0.477949,
      0,
      1,
      0.892236,
      0,
      0.723593,
      1.941607,
      0.525987,
      1.178906,
      0.939601,
      0.969519,
      0.204968,
      0.517911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '23332',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      0,
      2.232826,
      2,
      2,
      NULL,
      0,
      0,
      3);
commit;
end;
/


