set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2420',
      '33422212',
      2,
      58.721858,
      '1102412',
      NULL,
      1,
      3.396819,
      3,
      NULL,
      2,
      ' 7-22-1998',
      14,
      26.274046,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.196199,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      4.878131,
      1,
      1.113212,
      NULL,
      5.612970,
      NULL,
      0.280091,
      0.164923,
      NULL,
      1.278423,
      5,
      0,
      1,
      0.942368,
      1.259139,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.562721,
      NULL,
      1.079069,
      1.165827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.751099,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142881,
      0.812132,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0.362109,
      1.116235,
      NULL,
      1.148143,
      1,
      0,
      0.957599,
      1,
      NULL,
      NULL,
      NULL,
      0.804566,
      1.887719,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.423838,
      0.270544,
      0.779314,
      NULL,
      NULL,
      3.417239,
      3,
      7.177764,
      1,
      4.438082,
      NULL,
      3.379946,
      1,
      0.972586,
      1,
      1,
      NULL,
      NULL,
      3.270029,
      0.339121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257769,
      0,
      1,
      NULL,
      0.786848,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.764687,
      1,
      0.886538,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.909243,
      2,
      3.370834,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584040,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.394333,
      0,
      2.932328,
      0.206737,
      1.862690,
      0,
      1.355282,
      NULL,
      0,
      1,
      1,
      0.110677,
      NULL,
      1,
      0.893946,
      0,
      1.417442,
      0.216904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.077745,
      '22143',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      3.143471,
      3.131162,
      0,
      NULL,
      3.047182,
      1.264226,
      NULL,
      0.678718,
      NULL);
commit;
end;
/


