set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0102',
      '40002320',
      80,
      10.547061,
      '1041304',
      170,
      NULL,
      NULL,
      2,
      '114443',
      NULL,
      '10-15-1995',
      25,
      0,
      NULL,
      NULL,
      1.292331,
      0,
      NULL,
      1.897461,
      1.728216,
      0,
      0,
      3,
      NULL,
      0,
      5,
      1.413633,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.461813,
      1.862745,
      0,
      0,
      5.981400,
      1,
      2,
      3.652219,
      0.301951,
      0.768588,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.622112,
      0.425413,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616286,
      0,
      1.070461,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0.138965,
      0,
      0.745167,
      0.429687,
      NULL,
      1.204038,
      NULL,
      0,
      1.240231,
      0.253080,
      0,
      NULL,
      1,
      1.816776,
      NULL,
      NULL,
      NULL,
      0.460327,
      NULL,
      NULL,
      0.964504,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.933479,
      1,
      NULL,
      1,
      6,
      7,
      4.737658,
      7.534562,
      1.703913,
      NULL,
      2.707716,
      5.178308,
      1.844643,
      NULL,
      1,
      1.259266,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678864,
      0.715061,
      NULL,
      NULL,
      0.464024,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.616639,
      3.641111,
      1.280329,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.377181,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.888836,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949333,
      1,
      3,
      0.192667,
      2.469699,
      0.900481,
      2,
      1.716770,
      1,
      0.744586,
      NULL,
      NULL,
      NULL,
      1.004130,
      1,
      1,
      0.975525,
      1.836369,
      0,
      1.767397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '34212',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      3.931265,
      3.861766,
      0.561571,
      0,
      2,
      3,
      2,
      NULL);
commit;
end;
/


