set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1404',
      '30340233',
      14.544048,
      42,
      NULL,
      NULL,
      5,
      3,
      0,
      '114233',
      4,
      ' 8-25-1992',
      NULL,
      51,
      1.794910,
      NULL,
      0.343231,
      NULL,
      0.402845,
      0,
      NULL,
      1.479441,
      NULL,
      2.409489,
      0,
      NULL,
      0,
      1.632863,
      3.441230,
      0,
      4.987333,
      0.072555,
      1,
      1,
      0.379978,
      0,
      1.262301,
      1,
      5.606204,
      NULL,
      0.615062,
      0.688149,
      0.747338,
      NULL,
      NULL,
      NULL,
      0.198797,
      NULL,
      NULL,
      1,
      0,
      0.898508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.713291,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568269,
      NULL,
      1,
      1.632445,
      1,
      1.923753,
      1.561712,
      1.586916,
      0.722624,
      NULL,
      0.993933,
      1.665844,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.473875,
      0.334278,
      NULL,
      0,
      1.534328,
      NULL,
      1,
      1.157027,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023612,
      NULL,
      1.365686,
      1,
      0.895139,
      3,
      0.334935,
      7,
      7,
      NULL,
      4.792279,
      NULL,
      6,
      0,
      0.586411,
      NULL,
      0,
      NULL,
      NULL,
      9,
      1.533235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407542,
      0,
      1,
      0,
      1,
      0.108462,
      1.052460,
      0.758048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614382,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.117168,
      NULL,
      NULL,
      NULL,
      0.571205,
      1,
      0.126670,
      0,
      3.207455,
      1,
      0.544558,
      NULL,
      NULL,
      NULL,
      0.529331,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3.740592,
      1,
      1.597485,
      1,
      1.462343,
      1.647830,
      1.641756,
      0.418729,
      0.242835,
      1,
      0.130157,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '21140',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      3.518986,
      2,
      NULL);
commit;
end;
/


