set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7603326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      3.954347,
      NULL,
      0,
      1,
      NULL,
      1,
      ' 6- 1-1983',
      NULL,
      NULL,
      1.676662,
      NULL,
      1,
      1.740451,
      3.362146,
      1,
      1,
      NULL,
      NULL,
      3,
      0.159879,
      1.064192,
      6,
      1,
      0,
      1,
      NULL,
      NULL,
      1.733661,
      0.028794,
      0,
      1,
      1.758613,
      NULL,
      4.111742,
      1,
      2.254132,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.482184,
      NULL,
      NULL,
      0.458423,
      0.939517,
      0,
      NULL,
      NULL,
      1,
      3,
      2.593804,
      0,
      3.583133,
      2.051782,
      2.889766,
      0,
      2.049962,
      NULL,
      3.747916,
      NULL,
      0.522162,
      NULL,
      NULL,
      0.637214,
      0,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.906022,
      NULL,
      NULL,
      0.446656,
      0.027590,
      1.929177,
      1.088171,
      1,
      1,
      2,
      0.952529,
      1.212112,
      1,
      0.525492,
      0.060600,
      1.466698,
      0,
      1.179346,
      0,
      1.255264,
      1,
      0.526642,
      NULL,
      0.369010,
      1,
      0.655472,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.895867,
      3.436000,
      0.635868,
      2,
      0,
      3,
      6,
      NULL,
      1,
      6,
      6.021768,
      NULL,
      3,
      5,
      0.627226,
      NULL,
      NULL,
      8.690419,
      0.227230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237514,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526965,
      0.491142,
      1.088906,
      1,
      1.373751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981797,
      0,
      1.848342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941899,
      1.710690,
      1,
      0,
      1.628578,
      NULL,
      3.175029,
      1,
      2,
      1,
      0.740793,
      0.517600,
      0.719258,
      1.275682,
      NULL,
      0,
      1,
      1.645518,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788749,
      '43413',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


