set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '02',
      7,
      2.049564,
      '1434112',
      9,
      6,
      3.149001,
      1,
      '212404',
      0.600133,
      ' 8-18-2003',
      NULL,
      19,
      1.510298,
      NULL,
      0.368251,
      3,
      1,
      0.341894,
      0.276149,
      1,
      3.315653,
      1.429230,
      0.178327,
      NULL,
      3.860732,
      1,
      1,
      1,
      NULL,
      1.712721,
      0,
      1,
      0,
      1,
      1,
      0,
      3.391562,
      1,
      0,
      1,
      1.583865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.035147,
      1,
      1.746706,
      0.302336,
      1.998601,
      0,
      2,
      0.530276,
      2,
      0,
      2,
      NULL,
      0.039760,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      1,
      0,
      0.008267,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.049287,
      0.021895,
      1.732331,
      1.667367,
      NULL,
      0.475176,
      1.507632,
      NULL,
      NULL,
      NULL,
      0.130632,
      0,
      0.559819,
      1.370621,
      1,
      0,
      0,
      NULL,
      1.849019,
      NULL,
      1,
      0.943107,
      0.586556,
      0,
      1.322512,
      NULL,
      5.637707,
      0.601824,
      0.887575,
      NULL,
      0.447120,
      2,
      1.461699,
      NULL,
      1.232447,
      0,
      0.153373,
      2.516954,
      NULL,
      0,
      9.977963,
      1.255107,
      5.807349,
      1.211107,
      0,
      1.950316,
      NULL,
      NULL,
      0,
      2,
      1.150666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.695893,
      0,
      1.748546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250681,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.564624,
      0,
      1.804142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.076162,
      0.112013,
      1.570656,
      1.276693,
      1,
      0,
      0,
      NULL,
      3.339018,
      3.647031,
      NULL,
      1.430288,
      2.597550,
      1.540424,
      1.169676,
      2.380130,
      1,
      0,
      0,
      0,
      2,
      0.793405,
      0.172504,
      0,
      3,
      0.290347,
      0,
      1,
      1,
      0,
      2.214230,
      0.533884,
      3,
      0.208751,
      0.329604,
      0.689781,
      0,
      1.232783,
      NULL,
      1.427269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436326,
      2.472018,
      1,
      NULL,
      2.066203,
      2,
      NULL,
      1,
      0,
      '03134',
      '43211',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


