set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '314',
      NULL,
      17,
      21,
      '2133434',
      11,
      3,
      2.039445,
      0,
      NULL,
      NULL,
      NULL,
      37.836824,
      4,
      NULL,
      NULL,
      0.105619,
      NULL,
      0,
      1,
      NULL,
      1.568942,
      1.524551,
      NULL,
      1.850065,
      1,
      2,
      1.392668,
      2,
      0,
      0,
      0.772545,
      9,
      1,
      NULL,
      0,
      1.733515,
      1,
      3,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843789,
      NULL,
      0.199817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.821111,
      1.513283,
      1.912850,
      1.166362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.220267,
      2,
      5.940258,
      7.641668,
      0,
      0.440078,
      NULL,
      1,
      1.247017,
      NULL,
      1.390426,
      0,
      NULL,
      0.168404,
      NULL,
      1.591613,
      0.054589,
      1.528901,
      NULL,
      0.354817,
      NULL,
      1,
      1.216248,
      1,
      0.705145,
      1.056963,
      1.781657,
      NULL,
      0,
      0.369154,
      0,
      1,
      1.310257,
      4.886083,
      1.663991,
      0,
      1,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5.461053,
      1.117849,
      0.481311,
      0.174981,
      0.929982,
      3,
      0.119044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1.989204,
      1.301034,
      0.502092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.933614,
      NULL,
      0,
      0.302361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232299,
      2.492943,
      2.117914,
      1,
      NULL,
      1,
      1.821317,
      4.835485,
      0,
      2.693024,
      1,
      0.328268,
      1.995036,
      NULL,
      NULL,
      1.062186,
      1.022891,
      0.406451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.096696,
      1.835844,
      NULL,
      1,
      0,
      NULL,
      3.010092,
      NULL,
      0.264517,
      2,
      3.532449,
      NULL,
      0,
      NULL,
      NULL,
      0.625517,
      NULL,
      1.514665,
      1.689954,
      0.442396,
      0.720173,
      NULL,
      1.749578,
      1.201652,
      NULL,
      1.834864,
      0.872359,
      NULL,
      1,
      0,
      0,
      1.660979,
      0,
      0,
      1,
      0,
      1.191696,
      1.377449,
      1.732593,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024635,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944189,
      1.314618,
      0,
      NULL,
      NULL,
      1,
      1.566115,
      NULL,
      NULL,
      '40403',
      '20022',
      '24301',
      0,
      '',
      '',
      '',
      0.544702,
      '',
      NULL,
      '',
      5.653874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


