set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '20',
      23.168529,
      NULL,
      '4230433',
      0,
      0,
      2.412729,
      0,
      '202300',
      5,
      '10- 3-1989',
      48.944421,
      37,
      1,
      NULL,
      1.392897,
      0.717995,
      NULL,
      1,
      0,
      0.268327,
      3.982649,
      1.752657,
      1,
      0,
      0.416265,
      NULL,
      1,
      1,
      0.819363,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      1,
      0.958750,
      1,
      3.945642,
      0,
      1.279083,
      1.828657,
      NULL,
      NULL,
      0.783473,
      NULL,
      NULL,
      1,
      1,
      1.773101,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.700500,
      1.466115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941225,
      1,
      5.567865,
      2.605454,
      7,
      1,
      0.212153,
      NULL,
      NULL,
      0.897830,
      0,
      1,
      1,
      NULL,
      0,
      1.020621,
      1.141113,
      0,
      1,
      NULL,
      1,
      1.150294,
      1.989929,
      NULL,
      1.229150,
      0,
      0,
      0.107755,
      1.117953,
      NULL,
      NULL,
      0.047730,
      NULL,
      0,
      4,
      1,
      3,
      NULL,
      0.859171,
      0.411162,
      1.943942,
      5.219494,
      7.634860,
      NULL,
      NULL,
      1,
      2.626402,
      1.655416,
      2,
      0.091441,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.386038,
      1.561285,
      1.086868,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.696553,
      NULL,
      0.566486,
      3,
      1,
      2,
      NULL,
      NULL,
      2.605718,
      0,
      1,
      NULL,
      1,
      2.453428,
      2.845987,
      0.464796,
      1,
      NULL,
      1,
      2,
      NULL,
      3,
      2,
      5,
      0.783749,
      NULL,
      NULL,
      NULL,
      0.147635,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.770814,
      2.795512,
      0.055088,
      NULL,
      3,
      NULL,
      NULL,
      0.305912,
      2.483516,
      0,
      3,
      1.439302,
      0,
      3,
      NULL,
      NULL,
      1.014038,
      0.351752,
      0.414532,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.416038,
      0.015715,
      NULL,
      1,
      1,
      1,
      0.965474,
      1.910607,
      1,
      0,
      1.689086,
      1,
      0,
      0.035850,
      1.216133,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.521232,
      '42022',
      '24432',
      '11214',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


