set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41',
      36.245910,
      23,
      '0414140',
      13.195947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-26-1997',
      38.678362,
      36,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.435682,
      NULL,
      1.575558,
      1.939228,
      0.030039,
      5,
      0,
      1.578910,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857498,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.888708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210367,
      NULL,
      1.548999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321385,
      1.205863,
      0.993770,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.829446,
      6,
      2.102491,
      1.440719,
      1,
      0.978604,
      1.856704,
      1,
      NULL,
      0,
      NULL,
      1,
      0.769112,
      0,
      0.799161,
      0.053358,
      1.758912,
      NULL,
      0,
      1.762826,
      NULL,
      0.260974,
      NULL,
      0.478764,
      NULL,
      1.438808,
      NULL,
      1,
      1.171353,
      1,
      1.360644,
      1,
      0.816241,
      1.186405,
      0.541446,
      NULL,
      1,
      0,
      0,
      NULL,
      4.831762,
      5.116029,
      5.808866,
      0,
      4,
      NULL,
      1.125027,
      1.714697,
      1,
      0,
      1.934154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469773,
      0.315595,
      0,
      NULL,
      1,
      0,
      1,
      0.441144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.317840,
      1.025035,
      7,
      1.910004,
      NULL,
      0,
      NULL,
      0.444340,
      0,
      1.700094,
      NULL,
      1,
      3.561623,
      NULL,
      NULL,
      1.922794,
      NULL,
      NULL,
      NULL,
      4.219732,
      1.767963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.970982,
      1.251023,
      0,
      1.859762,
      1,
      0.090478,
      NULL,
      0,
      0.473308,
      2,
      2.823362,
      2.218679,
      2.039942,
      0.404817,
      0.030058,
      1.717956,
      0,
      0.729999,
      1.045532,
      1.761988,
      1.171875,
      1.167067,
      1.224732,
      1.861152,
      2.988372,
      2.935758,
      1.899756,
      1.122788,
      1.932391,
      0.921009,
      0.472237,
      0.160432,
      0.373337,
      0.955131,
      NULL,
      0,
      1.672457,
      1.848186,
      0.411125,
      1.835797,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428554,
      1.978940,
      1,
      NULL,
      NULL,
      0.283324,
      0,
      0,
      0,
      NULL,
      NULL,
      '31111',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.950305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


