set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      11,
      19.979542,
      '3221100',
      57.041085,
      6,
      1,
      0,
      '213314',
      3.062604,
      ' 8-18-1994',
      17,
      NULL,
      NULL,
      NULL,
      1.024113,
      2,
      1.704345,
      0.596637,
      1,
      0,
      NULL,
      NULL,
      0.982278,
      1,
      0.989032,
      NULL,
      1,
      NULL,
      0.174495,
      1,
      5.422608,
      1.915043,
      2,
      0,
      0.056104,
      0.342402,
      3,
      NULL,
      NULL,
      0.917957,
      1,
      NULL,
      NULL,
      NULL,
      1.775796,
      NULL,
      NULL,
      1,
      1.575447,
      1.908993,
      0.058113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816457,
      0,
      1.103235,
      0.409656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      6.237012,
      4.092172,
      NULL,
      NULL,
      1.496708,
      0.037230,
      0,
      1.094537,
      NULL,
      1.023647,
      0,
      1,
      0.204833,
      0.943604,
      0,
      1.193631,
      NULL,
      1.616052,
      1.384703,
      NULL,
      1.113588,
      NULL,
      0,
      1.266125,
      1.636079,
      NULL,
      0,
      1.519252,
      1,
      1,
      0.634385,
      2,
      0.759874,
      1,
      1,
      0,
      0.305451,
      3.284626,
      0,
      0,
      1,
      4,
      0,
      2.256217,
      3.777543,
      1,
      0,
      1,
      9,
      0.535466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075055,
      0,
      NULL,
      1,
      1,
      0,
      5.433675,
      1.733671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.880109,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559061,
      0.204206,
      0.191170,
      0,
      1.301154,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3.711302,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.936717,
      NULL,
      1.709975,
      3.640451,
      NULL,
      1,
      1,
      3,
      NULL,
      0.816160,
      2,
      3.057006,
      1.785172,
      1,
      1.109651,
      0.221921,
      NULL,
      1.066821,
      1,
      0,
      0,
      0.773815,
      3,
      3,
      2.198650,
      0.396018,
      2.165908,
      0.847188,
      1,
      1.973130,
      2,
      1,
      NULL,
      2,
      0,
      3.211926,
      1.811107,
      1.816817,
      0,
      1,
      NULL,
      0.930993,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600095,
      0.379427,
      0.247345,
      NULL,
      1.754378,
      NULL,
      NULL,
      0,
      NULL,
      '3201',
      '1302',
      '22032',
      1,
      '',
      '',
      '',
      0.140197,
      '',
      '',
      '',
      NULL,
      2.327099,
      1.781686,
      NULL,
      1,
      NULL,
      1.026337,
      1.481510,
      NULL);
commit;
end;
/


