set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      NULL,
      9,
      5,
      '4331000',
      29.276181,
      0,
      3.307506,
      0,
      NULL,
      5,
      ' 0-19-1999',
      22,
      6.014455,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.940167,
      2,
      1,
      0,
      NULL,
      0,
      0.447401,
      2,
      1,
      3.955172,
      0.327368,
      1.089869,
      0,
      0,
      1,
      NULL,
      1.824455,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.799724,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443836,
      1.780152,
      1.404712,
      1.876728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.741016,
      1,
      NULL,
      5.852321,
      0.767103,
      1,
      0,
      1,
      0.598866,
      NULL,
      1,
      0,
      1.684823,
      0,
      0.181804,
      0.565748,
      1,
      0,
      NULL,
      0.246522,
      1.819956,
      NULL,
      0.718277,
      0,
      1.377834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291144,
      0.830840,
      1.836124,
      1.286620,
      1,
      0.760050,
      0,
      NULL,
      3,
      2,
      1.126212,
      2,
      0.872620,
      0,
      2.860450,
      NULL,
      NULL,
      1,
      0.181573,
      5.570935,
      0.846679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.891459,
      NULL,
      0.783719,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.275386,
      0.988083,
      1.936164,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.394334,
      6,
      0.052876,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.650670,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.604117,
      NULL,
      0,
      2.607135,
      NULL,
      1,
      3,
      3.149587,
      1.062720,
      0.168883,
      0,
      3.643451,
      1,
      NULL,
      3,
      2,
      0.601743,
      0,
      1,
      0,
      1,
      1.048007,
      1,
      3,
      0.264639,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1.430533,
      0.815570,
      NULL,
      0.827354,
      0.161922,
      1.768413,
      NULL,
      1,
      NULL,
      0.028027,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022010,
      0,
      0,
      NULL,
      0,
      0,
      0.243000,
      0,
      1,
      '0141',
      '1004',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3.961864,
      3.406408,
      1,
      2.772860,
      1.118159,
      3,
      3,
      1.953785,
      1.988420);
commit;
end;
/


