set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34022303',
      NULL,
      50.085936,
      NULL,
      5,
      NULL,
      1,
      3,
      '223444',
      3,
      NULL,
      33.071396,
      39.818264,
      NULL,
      NULL,
      1,
      0,
      0.416067,
      1.087892,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      5,
      1,
      0,
      1.973579,
      NULL,
      1,
      4.564794,
      0.640370,
      NULL,
      0,
      1,
      0,
      1,
      0,
      3.861396,
      0.893600,
      1,
      1,
      NULL,
      NULL,
      0.694007,
      NULL,
      NULL,
      0,
      0,
      1.154924,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141452,
      NULL,
      1.483508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705188,
      1,
      2,
      7.521246,
      NULL,
      1.947754,
      0.930433,
      NULL,
      NULL,
      NULL,
      0.676712,
      1,
      1.754149,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1.041985,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.259529,
      1,
      0.368632,
      1.579921,
      1.601997,
      NULL,
      1.901260,
      4,
      0,
      NULL,
      4,
      1,
      NULL,
      0.110140,
      0.023437,
      0,
      0.457556,
      2,
      0.521096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.451748,
      0,
      0,
      1.453887,
      NULL,
      0.773980,
      1.771895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.522705,
      1.430004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      3.913811,
      2.417204,
      0,
      0,
      0.808067,
      1,
      3,
      NULL,
      0,
      1,
      1.384361,
      NULL,
      NULL,
      NULL,
      1.119313,
      2.956180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711804,
      3,
      2.183675,
      1.804088,
      1.092641,
      1.848380,
      NULL,
      NULL,
      0,
      1.652446,
      1.953214,
      NULL,
      3.591213,
      1,
      3.360574,
      NULL,
      3,
      1,
      0.640908,
      2,
      NULL,
      1,
      0,
      1.361136,
      1.691738,
      3,
      NULL,
      3.808817,
      2,
      3.921058,
      3,
      NULL,
      1.307568,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1.777920,
      1.608627,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083231,
      1,
      0,
      NULL,
      NULL,
      0,
      0.935151,
      NULL,
      NULL,
      '1332',
      '4212',
      '42032',
      NULL,
      '',
      '',
      NULL,
      4,
      '11431',
      '2023',
      '',
      0.273540,
      1.498984,
      1,
      2.151064,
      NULL,
      NULL,
      NULL,
      3,
      3);
commit;
end;
/


