set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      '20004234',
      29,
      NULL,
      '4012041',
      NULL,
      NULL,
      2,
      2,
      '443032',
      2,
      ' 4-12-1977',
      16.511976,
      10,
      NULL,
      NULL,
      0.914710,
      0,
      NULL,
      0,
      1.106459,
      0.021565,
      NULL,
      1.731922,
      0.405736,
      NULL,
      0.920782,
      1.432678,
      1.624443,
      0,
      1,
      1,
      7,
      1.605210,
      0.764273,
      0,
      1,
      0,
      0,
      NULL,
      3.750370,
      NULL,
      NULL,
      1.342272,
      NULL,
      NULL,
      1.875363,
      NULL,
      NULL,
      0,
      1,
      0.846320,
      0.245063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462753,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      1,
      1.038317,
      1,
      NULL,
      0,
      1.023617,
      0.019838,
      1.552860,
      1,
      1,
      0.929694,
      0,
      1.653029,
      1.942737,
      1.929585,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0.579824,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1.986024,
      1,
      1.498629,
      1,
      1.381460,
      NULL,
      0,
      1,
      4,
      4.419757,
      1.059792,
      1.853663,
      3.356938,
      0.629442,
      0,
      NULL,
      1,
      1,
      0.810872,
      1.386606,
      1.436577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5.105510,
      1.734240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.545547,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.534970,
      2,
      0,
      0.735914,
      NULL,
      0.052603,
      1.947591,
      1,
      0,
      0,
      3,
      3,
      1,
      NULL,
      2,
      NULL,
      0,
      1.131057,
      0,
      0,
      NULL,
      1.592515,
      NULL,
      2,
      3.920493,
      0,
      NULL,
      2.150414,
      2.561569,
      2.582324,
      2.077483,
      1.298571,
      NULL,
      1.814908,
      0,
      NULL,
      NULL,
      NULL,
      0.443100,
      1.378356,
      1,
      3.977343,
      1.365926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902012,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.174704,
      0,
      1.438277,
      NULL,
      1.581238,
      NULL,
      0.135349,
      NULL,
      3,
      NULL,
      '1331',
      '43130',
      0.449059,
      '',
      NULL,
      '',
      NULL,
      '00404',
      NULL,
      '',
      5,
      3,
      1.965130,
      NULL,
      3,
      NULL,
      2.833407,
      0.545528,
      2);
commit;
end;
/


