set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      '03343431',
      63,
      32,
      NULL,
      13,
      2,
      3.372398,
      1,
      '131341',
      NULL,
      ' 5-12-1996',
      120,
      7,
      0,
      NULL,
      0,
      1.925760,
      NULL,
      NULL,
      1.774158,
      3,
      0,
      3,
      3,
      3.106369,
      0.641464,
      0,
      2,
      0,
      0.651556,
      0.189371,
      4.361684,
      1,
      1.368600,
      0,
      1,
      1.578833,
      6,
      1,
      NULL,
      0,
      0,
      0.495388,
      NULL,
      NULL,
      1.076860,
      NULL,
      NULL,
      9,
      9.109938,
      0,
      0,
      1,
      0.099229,
      NULL,
      NULL,
      1.918309,
      0.710142,
      1.282213,
      1,
      0,
      2,
      1,
      0.065748,
      2.317649,
      2.620417,
      1.211470,
      1,
      0.039996,
      1.625748,
      2.675465,
      0,
      0,
      0,
      1.604169,
      NULL,
      NULL,
      0.203770,
      NULL,
      NULL,
      0,
      NULL,
      2.851343,
      0,
      NULL,
      NULL,
      4,
      0.584495,
      1,
      5.886170,
      3,
      NULL,
      0,
      5,
      0,
      0,
      1,
      0.431529,
      NULL,
      NULL,
      NULL,
      0.827758,
      5,
      3,
      0,
      0.186038,
      NULL,
      NULL,
      1,
      NULL,
      0.802949,
      1,
      0,
      1,
      2,
      2.431438,
      NULL,
      NULL,
      NULL,
      6.924724,
      9,
      0.805913,
      NULL,
      9,
      9.605164,
      0.371723,
      NULL,
      NULL,
      2.475169,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119675,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.993425,
      NULL,
      5,
      0,
      0,
      2,
      0.742348,
      NULL,
      1.203753,
      1,
      9.539323,
      2.490881,
      2.323862,
      0.188804,
      NULL,
      NULL,
      NULL,
      1,
      0.245157,
      4.224410,
      NULL,
      1.447206,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.946481,
      1.836370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.407345,
      0,
      3.460518,
      NULL,
      NULL,
      3.435303,
      1,
      0,
      0,
      0.519274,
      1,
      1,
      1.386562,
      0.114397,
      NULL,
      1,
      0.124245,
      0,
      1.746214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.488663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.397489,
      '21240',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      5.484759,
      2.929196,
      5.932166,
      3.784241,
      3.032581,
      1,
      NULL,
      2.161056,
      NULL);
commit;
end;
/


