set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      NULL,
      61,
      61,
      '0412320',
      26,
      6,
      NULL,
      NULL,
      '244440',
      3,
      ' 8-25-2003',
      169,
      0.645289,
      NULL,
      NULL,
      2,
      1,
      3,
      1.251755,
      0.173101,
      1,
      1,
      NULL,
      1,
      0,
      4.838542,
      1.686587,
      3,
      1.710924,
      0.242268,
      0.470515,
      3,
      1,
      1,
      1,
      0.453252,
      1,
      1.843598,
      NULL,
      1,
      NULL,
      1,
      0.825277,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.922215,
      1.302556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.431762,
      1,
      1.703871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      2.875881,
      0,
      1.604373,
      1,
      0.174427,
      NULL,
      NULL,
      0.258624,
      1.968372,
      0,
      NULL,
      1.222639,
      0.729844,
      NULL,
      0,
      1,
      NULL,
      1.342547,
      1.063070,
      NULL,
      4.757894,
      0,
      0.472804,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1.298308,
      4.366246,
      5,
      0,
      NULL,
      NULL,
      5.229774,
      3,
      6,
      2,
      1.038122,
      3,
      1.175667,
      NULL,
      NULL,
      4.420849,
      0.726473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.967166,
      0,
      0,
      0.163299,
      1,
      NULL,
      0.825644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.966058,
      1.152452,
      1.145456,
      NULL,
      1.112278,
      3,
      1.520125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.125897,
      1,
      2.776552,
      0.036852,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.428765,
      1.740840,
      0.417526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.310504,
      0,
      1,
      1,
      NULL,
      1.619156,
      1,
      0,
      1.883755,
      0.048398,
      NULL,
      1.941872,
      1,
      1,
      1.737003,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '43010',
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      0.277410,
      '',
      '',
      '',
      0,
      3.847725,
      NULL,
      3,
      3,
      1,
      2,
      2.376582,
      0);
commit;
end;
/


